/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinGrowthsRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import org.jetbrains.annotations.Nullable;

public abstract class BuiltinBlockGrowth
implements IBlockGrowth {
    public static final Codec<BuiltinBlockGrowth> CODEC = Codec.STRING.partialDispatch("builtin", b -> DataResult.success((Object)b.getName()), n -> {
        BuiltinGrowthsRegistry.BuiltinGrowthFactory factory = BuiltinGrowthsRegistry.BUILTIN_GROWTHS.get(n);
        if (factory == null) {
            return DataResult.error((String)("No builtin growth found with id " + n));
        }
        Codec codec = RecordCodecBuilder.create(i -> i.group((App)TickSource.CODEC.listOf().optionalFieldOf("tick_sources", List.of(TickSource.BLOCK_TICK)).forGetter(b -> b.sources), (App)class_6895.method_40340((class_5321)class_2378.field_25105).optionalFieldOf("owners").forGetter(b -> Optional.ofNullable(b.owners)), (App)Codec.FLOAT.optionalFieldOf("growth_chance", (Object)Float.valueOf(1.0f)).forGetter(b -> Float.valueOf(b.growthChance))).apply((Applicative)i, (o, s, c) -> factory.create((String)n, (class_6885<class_2248>)((class_6885)s.orElse(null)), (List<TickSource>)o, c.floatValue())));
        return DataResult.success((Object)codec);
    });
    private final class_6885<class_2248> owners;
    private final String name;
    private final List<TickSource> sources;
    protected final float growthChance;

    protected BuiltinBlockGrowth(String name, @Nullable class_6885<class_2248> owners, List<TickSource> sources, float chance) {
        this.owners = owners;
        this.name = name;
        this.sources = sources;
        this.growthChance = chance;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Iterable<? extends class_2248> getOwners() {
        if (this.owners == null) {
            return null;
        }
        return this.owners.method_40239().map(class_6880::comp_349).toList();
    }

    @Override
    public final Collection<TickSource> getTickSources() {
        return this.sources;
    }
}

